﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Azyobuzi.りすにんぐついったー 
{
    interface IMusicDataListener : IDisposable
    {
        event EventHandler<ListeningMusicChangedEventArgs> ListeningMusicChanged;
        bool Enable { set; get; }
        void Start();
        void Stop();
    }

    public class ListeningMusicChangedEventArgs : EventArgs 
    {
        public ListeningMusicChangedEventArgs(string title, string artist, string album) 
        {
            this.title = title;
            this.artist = artist;
            this.album = album;
        }

        private string title;
        public string Title 
        {
            get 
            {
                return title;
            }
        }

        private string artist;
        public string Artist 
        {
            get 
            {
                return artist;
            }
        }

        private string album;
        public string Album 
        {
            get 
            {
                return album;
            }
        }
    }
}
